﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Data.SqlClient;
using System.Data.Odbc;
using System.Data;

namespace Chapter_20
{
    class Program
    {
        static void Main(string[] args)
        {
            // niezbyt optymalnie
            //var conn = new SqlConnection("Data Source=GLIWICE;Initial Catalog=Hospital;Integrated Security=True");
            //var cmd = new SqlCommand("select * from Patient", conn);

            //conn.Open();

            //SqlDataReader rdr = cmd.ExecuteReader();

            //while (rdr.Read())
            //{
            //    Console.WriteLine("Imię: {0}", rdr["Name"]);
            //}

            //rdr.Close();
            //conn.Close();

            // właściwe zwolnienie zasobów

            string connStr = "Data Source=GLIWICE;Initial Catalog=Hospital;Integrated Security=True";
            string queryStr = "select * from Patient";

            using (var conn = new SqlConnection(connStr))
            using (var cmd = new SqlCommand(queryStr, conn))
            {
                conn.Open();

                using (SqlDataReader rdr = cmd.ExecuteReader())
                {
                    while (rdr.Read())
                    {
                        Console.WriteLine("Imię: {0}", rdr["Name"]);
                    }
                }
            }

            // pozycjonowanie porządkowe działa lepiej

            using (var conn = new SqlConnection(connStr))
            using (var cmd = new SqlCommand(queryStr, conn))
            {
                conn.Open();

                using (SqlDataReader rdr = cmd.ExecuteReader())
                {
                    int namePos = rdr.GetOrdinal("Name");

                    while (rdr.Read())
                    {
                        Console.WriteLine("Imię: {0}", rdr.GetString(namePos));
                    }
                }
            }

            // modyfikacja danych

            string insertStr = "insert into Patient (Name, DoctorID) values (@Name, @DoctorID)";

            using (var conn = new SqlConnection(connStr))
            using (var cmd = new SqlCommand(insertStr, conn))
            {
                cmd.Parameters.AddWithValue("@Name", "Jan");
                cmd.Parameters.AddWithValue("@DoctorID", 1);

                conn.Open();

                cmd.ExecuteNonQuery();
            }

            string updateStr = "update Patient set Name = @Name, DoctorID = @DoctorID where PatientID = @PatientID";

            using (var conn = new SqlConnection(connStr))
            using (var cmd = new SqlCommand(updateStr, conn))
            {
                cmd.Parameters.AddWithValue("@PatientID", 6);
                cmd.Parameters.AddWithValue("@Name", "JanM");
                cmd.Parameters.AddWithValue("@DoctorID", 1);

                conn.Open();

                cmd.ExecuteNonQuery();
            }

            string deleteStr = "delete from Patient where PatientID = @PatientID";

            using (var conn = new SqlConnection(connStr))
            using (var cmd = new SqlCommand(deleteStr, conn))
            {
                cmd.Parameters.AddWithValue("@PatientID", 6);

                conn.Open();

                cmd.ExecuteNonQuery();
            }

            // procedury składowane

            using (var conn = new SqlConnection(connStr))
            using (var cmd = new SqlCommand("InsertPatient", conn))
            {
                cmd.CommandType = CommandType.StoredProcedure;

                cmd.Parameters.AddWithValue("@Name", "Jan");
                cmd.Parameters.AddWithValue("@DoctorID", 1);

                conn.Open();

                cmd.ExecuteNonQuery();
            }

            // użycie obiektów DataSets i DataAdapters

            var dsConn = new SqlConnection(connStr);

            var dsPatients = new DataSet();

            var daPatients =
                new SqlDataAdapter("select * from Patient", dsConn);

            var insertCommand = new SqlCommand(
                "insert into Patient (Name, DoctorID) values (@Name, @DoctorID)", 
                dsConn);
            insertCommand.Parameters.AddRange(
                new SqlParameter[] {
                    new SqlParameter()
                    {
                        ParameterName = "@Name",
                        SourceColumn = "Name"
                    },
                    new SqlParameter()
                    {
                        ParameterName = "@DoctorID",
                        SourceColumn = "DoctorID",
                        SqlDbType = SqlDbType.Int
                   }
                }
            );

            daPatients.InsertCommand = insertCommand;

            var updateCommand = new SqlCommand(
    "update Patient set Name = @Name, DoctorID = @DoctorID where PatientID = @PatientID",
    dsConn);
            updateCommand.Parameters.AddRange(
                new SqlParameter[] {
                    new SqlParameter()
                    {
                        ParameterName = "@Name",
                        SourceColumn = "Name"
                    },
                    new SqlParameter()
                    {
                        ParameterName = "@DoctorID",
                        SourceColumn = "DoctorID",
                        SqlDbType = SqlDbType.Int
                    },
                    new SqlParameter()
                    {
                        ParameterName = "@PatientID",
                        SourceColumn = "PatientID",
                        SqlDbType = SqlDbType.Int
                    }
                }
            );

            daPatients.UpdateCommand = updateCommand;

            var deleteCommand = new SqlCommand(
    "delete from Patient where PatientID = @PatientID",
    dsConn);
            deleteCommand.Parameters.Add(
                new SqlParameter()
                    {
                        ParameterName = "@PatientID",
                        SourceColumn = "PatientID",
                        SqlDbType = SqlDbType.Int
                    }
            );

            daPatients.DeleteCommand = deleteCommand;

            daPatients.Fill(dsPatients, "Patients");

            DataTable tblPatient = dsPatients.Tables["Patients"];

            foreach (DataRow row in tblPatient.Rows)
            {
                Console.WriteLine("Imię pacjenta: {0}", row["Name"]);
            }
                        
            // wstaw nowy rekord
            DataRow newRow = tblPatient.NewRow();

            newRow["PatientID"] = -1;
            newRow["Name"] = "Janina";
            newRow["DoctorID"] = 1;

            tblPatient.Rows.Add(newRow);

            // aktualizuj istniejący rekord
            tblPatient.Rows[0]["Name"] += "X";

            // usuń rekord
            foreach (DataRow row in tblPatient.Rows)
            {
                if (row["Name"] as string == "Jan")
                {
                    row.Delete();
                    break;
                }
            }

            // zapisywanie zmian do bazy danych
            daPatients.Update(dsPatients, "Patients");

            var tblStaff = new DataTable("HospitalStaff");

            tblStaff.Columns.AddRange(
                new DataColumn[]
                {
                    new DataColumn("HospitalStaffID", typeof(int)),
                    new DataColumn("Name"),
                    new DataColumn("Position")
                }
            );

            var addedRow = tblStaff.NewRow();

            addedRow["HospitalStaffID"] = 1;
            addedRow["Name"] = "Marek";
            addedRow["Position"] = "Lekarz";

            tblStaff.Rows.Add(addedRow);

            addedRow = tblStaff.NewRow();

            addedRow["HospitalStaffID"] = 2;
            addedRow["Name"] = "Marcela";
            addedRow["Position"] = "Pielęgniarka";

            tblStaff.Rows.Add(addedRow);

            tblStaff.PrimaryKey = new DataColumn[] 
                { tblStaff.Columns["HospitalStaffID"] };
            tblPatient.PrimaryKey = new DataColumn[] 
                { tblPatient.Columns["PatientID"] };

            dsPatients.Tables.Add(tblStaff);

            dsPatients.Relations.Add(
                new DataRelation(
                    "StaffPatients",
                    tblStaff.Columns["HospitalStaffID"],
                    tblPatient.Columns["DoctorID"]));

            DataRow jane = tblPatient.Rows.Find(3);
            DataRow janesDoctor = jane.GetParentRow("StaffPatients");

            Console.WriteLine("Lekarz Janiny: {0}", janesDoctor["Name"]);

            foreach (var docPatient in janesDoctor.GetChildRows("StaffPatients"))
            {
                Console.WriteLine("Lekarz Janiny: {0}; jego pacjent: {1}",
                    janesDoctor["Name"], docPatient["Name"]);
            }

            // LINQ to DataSet

            DataTable tblPatients = dsPatients.Tables["Patients"];

            var patientsEnumerable =
                from patient in tblPatients.AsEnumerable()
                select patient;

            foreach (var patient in patientsEnumerable)
            {
                Console.WriteLine("Wyliczenie pacjentów: {0}", patient["Name"]);
            }

            var patientsFields =
                from patient in tblPatients.AsEnumerable()
                where patient.Field<string>("Name").StartsWith("Grzegorz")
                select patient;

            foreach (var patient in patientsFields)
            {
                Console.WriteLine(
                    "Pole Patient o ścisłej kontroli typów: {0}", 
                    patient.Field<string>("Name"));
            }

            Console.ReadKey();
        }
    }
}
